package examples.jndi;

import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

/**
 * The implementation of a remote object which generates primary keys
 */
public class PrimaryKeyGeneratorImpl 
	extends PortableRemoteObject 
	implements PrimaryKeyGenerator {
	
	private static long i = System.currentTimeMillis();
	
	public PrimaryKeyGeneratorImpl() throws Exception, RemoteException {
		/*
		 * Since we extend PortableRemoteObject, the super
		 * class will export our remote object here.
		 */
		super();
	}

	/**
	 * Generates a unique primary key
	 */
	public synchronized long generate() throws RemoteException {
		return i++;
	}
}